<?php
/** A simple rich textarea block **/
class AQ_Richtext_Block extends AQ_Block {

	//set and create block
	function __construct() {
		$block_options = array(
			'name' => 'Editeur de texte',
			'size' => 'span6',
		);

		//create the block
		parent::__construct('aq_richtext_block', $block_options);
	}

	function form($instance) {

		$defaults = array(
			'text' => ''
		);
		$instance = wp_parse_args($instance, $defaults);
		extract($instance);

		?>
		<p class="description">
			<label for="<?php echo $this->get_field_id('title') ?>">
				Titre (optionnel)
				<?php echo aq_field_input('title', $block_id, $title, $size = 'full') ?>
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('text') ?>">
				Contenu
				<?php 
				$args = array (
				    'tinymce' => array(
            'plugins' => 'safari,inlinepopups,spellchecker,paste,wordpress,media,fullscreen,wpeditimage,wpgallery,tabfocus',
            'theme_advanced_buttons1' => 'bold, italic, underline, strikethrough, forecolor, separator, bullist, numlist, separator, link, unlink, justifyleft, justifycenter, justifyright,',
            'theme_advanced_buttons2' => 'formatselect,forecolor,',
			'theme_advanced_blockformats' => 'p,address,pre,h1,h2,h3,h4,h5,h6',
            ),
				    'quicktags' => true,
					
				);
				wp_editor( htmlspecialchars_decode($text), 'aq_blocks['.$block_id.'][text]', $args );
				?>
			</label>
		</p>
		
		<?php
	}

	function block($instance) {
		extract($instance);
		echo '<div id="editor-rich" class="row">';
		echo'<div class="sixteen-editor columns">';
		if($title) echo '<h2 class="title-video"><span>'.strip_tags($title).'</span></h2>';
		echo wpautop(do_shortcode(htmlspecialchars_decode($text)));
		echo '</div>';
		echo '</div>';
	}

}