<?php
/** 
Plugin Name: Custom Pager
Plugin URI: http://naxialis.com
Description:   Requires PHP5 and WP3.5
Version: 1.0.6
Author: Fred
Author URI: http://naxialis.com

Copyright (c) 2013 Fred rights reserved.
*/
//definitions
if(!defined('AQPB_VERSION')) define( 'AQPB_VERSION', '1.0.6' );
if(!defined('AQPB_PATH')) define( 'AQPB_PATH', plugin_dir_path(__FILE__) );
if(!defined('AQPB_DIR')) define( 'AQPB_DIR', plugin_dir_url(__FILE__) );

//required functions & classes
require_once(AQPB_PATH . 'functions/aqpb_config.php');
require_once(AQPB_PATH . 'functions/aqpb_blocks.php');
require_once(AQPB_PATH . 'functions/aqpb_post.php');
require_once(AQPB_PATH . 'classes/class-custom_pager.php');
require_once(AQPB_PATH . 'classes/class-aq-block.php');
//require_once(AQPB_PATH . 'classes/class-aq-plugin-updater.php');
require_once(AQPB_PATH . 'functions/aqpb_functions.php');

//some default blocks
require_once(AQPB_PATH . 'blocks/aq-post-vertical.php');
require_once(AQPB_PATH . 'blocks/aq-portfolio.php');
require_once(AQPB_PATH . 'blocks/aq-post-vertical-2.php');
require_once(AQPB_PATH . 'blocks/aq-post-block.php');
require_once(AQPB_PATH . 'blocks/aq-text-block.php');
require_once(AQPB_PATH . 'blocks/aq-ticker-block.php');
require_once(AQPB_PATH . 'blocks/aq-social-block.php');
require_once(AQPB_PATH . 'blocks/aq-google-map-block.php');
require_once(AQPB_PATH . 'blocks/aq-text-editor.php');
require_once(AQPB_PATH . 'blocks/aq-team-block.php');
require_once(AQPB_PATH . 'blocks/aq-column-block.php');
require_once(AQPB_PATH . 'blocks/aq-clear-block.php');
require_once(AQPB_PATH . 'blocks/aq-video-player-block.php');
require_once(AQPB_PATH . 'blocks/aq-video-player-media-block.php');
require_once(AQPB_PATH . 'blocks/aq-separator-block.php');
require_once(AQPB_PATH . 'blocks/aq-widgets-block.php');
//require_once(AQPB_PATH . 'blocks/aq-alert-block.php');
require_once(AQPB_PATH . 'blocks/aq-tabs-block.php');
require_once(AQPB_PATH . 'blocks/aq-slide-block.php');
require_once(AQPB_PATH . 'blocks/aq-slideshow.php');

//register default blocks
aq_register_block('AQ_post_vertical_Block');
aq_register_block('AQ_Portfolio_Block');
aq_register_block('AQ_post_vertical_2_Block');
aq_register_block('AQ_post_Block');
aq_register_block('AQ_Text_Block');
aq_register_block('AQ_Ticker_Block');
aq_register_block('AQ_Social_Block');
aq_register_block('AQ_Google_Map_Block');
aq_register_block('AQ_richtext_block');
aq_register_block('AQ_Team_Block');
aq_register_block('AQ_Column_Block');
aq_register_block('AQ_Clear_Block');
aq_register_block('AQ_Video_Player_Block');
aq_register_block('AQ_Video_Player_Media_Block');
aq_register_block('AQ_Separator_Block');
aq_register_block('AQ_Widgets_Block');
// aq_register_block('AQ_Alert_Block');
aq_register_block('AQ_Tabs_Block');
aq_register_block('AQ_Slide_Block');
aq_register_block('AQ_Slideshow_Block');

//fire up Custom Pager
$aqpb_config = aq_page_builder_config();
$aq_page_builder =& new AQ_Page_Builder($aqpb_config);
if(!is_network_admin()) $aq_page_builder->init();