<?php
/**
 * Aqua Custom Pager Config
 *
 * This file handles various configurations
 * of the page builder page
 *
 */
function aq_page_builder_config() {

	$config = array(); //initialise array
	
	/* Page Config */
	$config['menu_title'] = __('Custom Pager', 'framework');
	$config['page_title'] = __('Custom Pager', 'framework');
	$config['page_slug'] = __('aq-page-builder', 'framework');
	
	/* This holds the contextual help text - the more info, the better.
	 * HTML is of course allowed in all of its glory! */
	$config['contextual_help'] = 
		'<p>' . __('Custom pager vous permet de créer des modèles de page personnalisés que vous pourrez ensuite utiliser dans vos pages.', 'framework') . '<p>' .
		'<p>' . __('Pour utiliser Custom pager, commencez par ajouter un nouveau modèle. Ensuite vous pouvez glisser et déposer les blocs sur la gauche dans la zone de construction sur la droite de l&acute;écran. Chaque bloc possède sa propre configuration unique que vous pouvez paramétrer manuellement en fonction de vos besoins.', 'framework') . '<p>';
	
	/* Debugging */
	$config['debug'] = false;
	
	return $config;
	
}