<?php

@include_once 'commons.php';

$options = get_option('newsletter_main');

if ($action == 'save') {
    $options = stripslashes_deep($_POST['options']);
    update_option('newsletter_main', $options);
}

$nc = new NewsletterControls($options);

?>

<div class="wrap">

    <h2><?php _e('Newsletter Configuration', 'newsletter'); ?></h2>

    <?php require_once 'header.php'; ?>

    <p>
        
    </p>
    
    <form method="post" action="">
        <?php wp_nonce_field(); ?>
        <input type="hidden" value="<?php echo NEWSLETTER; ?>" name="options[version]"/>

        <h3><?php _e('Param&egrave;tres g&eacute;n&eacute;raux', 'newsletter'); ?></h3>
        <table class="form-table">
            <tr valign="top">
                <th><?php _e('Activer l&acute;acc&egrave;s pour les &eacute;diteurs de wordpress?', 'newsletter'); ?></th>
                <td>
                    <?php $nc->yesno('editor'); ?>
                </td>
            </tr>
            <tr valign="top">
                <th><?php _e('Toujours afficher les panneaux en anglais?', 'newsletter'); ?></th>
                <td>
                    <?php $nc->yesno('no_translation'); ?>
                    <br />
                    <?php _e('L&acute;auteur ne maintient pas les traductions, si vous avez un doute sur certains textes, d&eacute;sactiver les traductions(vous pouvez laisser sur no)', 'newsletter'); ?>
                </td>
            </tr>
            <tr valign="top">
                <th><?php _e('Logging', 'newsletter'); ?></th>
                <td>
                    <?php $nc->select('logs', array(0=>'None', 1=>'Normal', 2=>'Debug')); ?>
                    <br />
                    <?php _e('Niveau de d&eacute;bogage enregistre les donn&eacute;es utilisateur sur le syst&egrave;me de fichier, utilisez uniquement pour d&eacute;boguer les probl&egrave;mes.', 'newsletter'); ?>
                </td>
            </tr>
        </table>
        <p class="submit">
            <?php $nc->button('save', __('Enregistrer', 'newsletter')); ?>
        </p>
    </form>
</div>
