<?php
/*
Plugin Name: Posts Plugin post type
Plugin URI: http://naxialis.com
Description: Displays a list of your latest posted articles.
Version: 1.2
Author: Fred
Author URI: http://naxialis.com
*/
wp_enqueue_style('sprp2', '/wp-content/plugins/recent_posts/css/sprp2.css');

class NaxialisWidget extends WP_Widget {
    function NaxialisWidget() {
        parent::WP_Widget(false, $name = 'Naxialis Recent Posts');	
    }

//Widget
function form($instance) {				
        $title = esc_attr($instance['title']);
        $dis_posts = esc_attr($instance['dis_posts']);
		$excerpt_posts = esc_attr($instance['excerpt_posts']);
		$cat_posts = esc_attr($instance['cat_posts']);
		$post_type = esc_attr($instance['post_type']);
		
		$posttypes = get_post_types(null, 'objects');
		$posttypes_opt = array('post'=>'post','page'=>'page');
		
		foreach( $posttypes as $id => $obj ) {
			if(!$obj->_builtin)
				$posttypes_opt[$id] = $obj->labels->name;
		}
		
        ?>
            <p><label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Titre:'); ?> <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" /></label></p>
     		<p><label for="<?php echo $this->get_field_id('dis_posts'); ?>"><?php _e("Nombre d'article à afficher:"); ?> <input class="widefat" id="<?php echo $this->get_field_id('dis_posts'); ?>" name="<?php echo $this->get_field_name('dis_posts'); ?>" type="text" value="<?php echo $dis_posts; ?>" /></label></p>
            <p><label for="<?php echo $this->get_field_id('excerpt_posts'); ?>"><?php _e("Longueur de l'extrait:"); ?> <input class="widefat" id="<?php echo $this->get_field_id('excerpt_posts'); ?>" name="<?php echo $this->get_field_name('excerpt_posts'); ?>" type="text" value="<?php echo $excerpt_posts; ?>" /></label></p>
            
            <p><label for="<?php echo $this->get_field_id('post_type'); ?>"><?php _e('Post Type:'); ?></label>
		<select id="<?php echo $this->get_field_id('post_type'); ?>" name="<?php echo $this->get_field_name('post_type'); ?>">
       		<?php foreach($posttypes_opt as $id => $post_type){ ?>
            		<option value="<?php echo $id?>" <?php echo selected($id, $instance['post_type'])?>><?php echo $post_type?></option>
			<?php } ?>
        </select>
        	</p>
            
			<p><label><?php _e( 'Categorie' ); ?>:</label>
<?php wp_dropdown_categories( array( 'show_option_all' => __('ALL'),'hide_empty'  => 0,'name' => $this->get_field_name("cat_posts"), 'selected' => $instance["cat_posts"] ) ); ?>
			</p>
        <?php 
    }	




function widget($args, $instance) {
	

        extract( $args );
        $title = apply_filters('widget_title', $instance['title']);
		$dis_posts = $instance['dis_posts'];
		$cat_posts = $instance['cat_posts'];
		$post_type = $instance['post_type'];
		$excerpt_posts = $instance['excerpt_posts'];


	
 echo $before_widget; 
 if ( $title )
 echo $before_title . $title . $after_title; ?>
 
                           <ul id="sprp_recent_post">
                             <?php
                             global $post;
                             $args = array( 'showposts' 	  => $dis_posts,
							 				'post_type' 	  => $post_type,
							 				'cat'	  		  => $cat_posts,
										
											 );
											
                             $the_query = new WP_Query($args);
							 while ($the_query->have_posts()) : $the_query->the_post(); ?>
                             
	                           <div class="sprp_recent_dt">
                               <?php if (has_post_thumbnail()) { ?>
							   <?php $thumb = get_post_thumbnail_id(); $img_url = wp_get_attachment_url( $thumb,'full' ); $image = sp_post_resize( $img_url, 50, 50, true ); ?>
							   <a href=" <?php echo get_permalink();?>" title="<?php the_title(); ?>"><img class="sp_image_post_2" src="<?php echo $image ?>" border="0"/></a>
                               <?php  } else { ?><a href="<?php the_permalink() ?>" rel="bookmark" title="<?php printf(__('%s'), the_title_attribute('echo=0')); ?>"><img class="sp_image_post_2" src="<?php bloginfo('template_url'); ?>/images/no_picture_available.jpg" width="50" height="50" border="0"/></a>  <?php } ?>
                               <strong><?php the_title(); ?></strong></br>
                               
                               <p class="sprp_recent_txt"><?php echo excerpt_sprp($excerpt_posts);?></p>
                               </div> 
							     <div class="post-types-clear"></div>
                             <?php endwhile; ?>
                        
                           </ul>
						
               <?php echo $after_widget; ?>
<?php
    }
	
} 
	
	
	
	
		// Thumbnail Function
function sp_post_resize( $url, $width, $height = null, $crop = null, $single = true ) {

	//validate inputs
	if(!$url OR !$width ) return false;

	//define upload path & dir
	$upload_info = wp_upload_dir();
	$upload_dir = $upload_info['basedir'];
	$upload_url = $upload_info['baseurl'];

	//check if $img_url is local
	if(strpos( $url, $upload_url ) === false) return false;

	//define path of image
	$rel_path = str_replace( $upload_url, '', $url);
	$img_path = $upload_dir . $rel_path;

	//check if img path exists, and is an image indeed
	if( !file_exists($img_path) OR !getimagesize($img_path) ) return false;

	//get image info
	$info = pathinfo($img_path);
	$ext = $info['extension'];
	list($orig_w,$orig_h) = getimagesize($img_path);

	//get image size after cropping
	$dims = image_resize_dimensions($orig_w, $orig_h, $width, $height, $crop);
	$dst_w = $dims[4];
	$dst_h = $dims[5];

	//use this to check if cropped image already exists, so we can return that instead
	$suffix = "{$dst_w}x{$dst_h}";
	$dst_rel_path = str_replace( '.'.$ext, '', $rel_path);
	$destfilename = "{$upload_dir}{$dst_rel_path}-{$suffix}.{$ext}";

	//if orig size is smaller
	if($width >= $orig_w) {

		if(!$dst_h) :
			//can't resize, so return original url
			$img_url = $url;
			$dst_w = $orig_w;
			$dst_h = $orig_h;

		else :
			//else check if cache exists
			if(file_exists($destfilename) && getimagesize($destfilename)) {
				$img_url = "{$upload_url}{$dst_rel_path}-{$suffix}.{$ext}";
			} 
			//else resize and return the new resized image url
			else {
				$resized_img_path = image_resize( $img_path, $width, $height, $crop );
				$resized_rel_path = str_replace( $upload_dir, '', $resized_img_path);
				$img_url = $upload_url . $resized_rel_path;
			}

		endif;

	}
	//else check if cache exists
	elseif(file_exists($destfilename) && getimagesize($destfilename)) {
		$img_url = "{$upload_url}{$dst_rel_path}-{$suffix}.{$ext}";
	} 
	//else, we resize the image and return the new resized image url
	else {
		$resized_img_path = image_resize( $img_path, $width, $height, $crop );
		$resized_rel_path = str_replace( $upload_dir, '', $resized_img_path);
		$img_url = $upload_url . $resized_rel_path;
	}

	//return the output
	if($single) {
		//str return
		$image = $img_url;
	} else {
		//array return
		$image = array (
			0 => $img_url,
			1 => $dst_w,
			2 => $dst_h
		);
	}

	return $image;
}

add_action('widgets_init', create_function('', 'return register_widget("NaxialisWidget");')); 

// Excerpt function custom
function excerpt_sprp($limit) {
      $excerpt = explode(' ', get_the_excerpt(), $limit);
      if (count($excerpt)>=$limit) {
        array_pop($excerpt);
        $excerpt = implode(" ",$excerpt).'';
      } else {
        $excerpt = implode(" ",$excerpt);
      } 
      $excerpt = preg_replace('`\[[^\]]*\]`','',$excerpt);
      return $excerpt;
    }
?>