<?php 
//Gets values from database
$options = get_option('sfa_settings');
$admin_error['msg'] ='';
$sfa_error = false;
$sfa_font_error = false;
$sfa_font_msg ='';

if( isset($_POST['sfa_font_submit'] )) 
{	 $allow = array('.ttf'); // These will be the types of file that will pass the validation.
      $max_filesize = 524288; // Maximum filesize in BYTES (currently 0.5MB).
      $upload_path = WP_PLUGIN_DIR ."/smart-form-ajax/fonts/"; // The place the files will be uploaded to (currently a 'files' directory).
	  

	
   $filename = $_FILES['userfile']['name']; // Get the name of the file (including file extension).
   $ext = substr($filename, strpos($filename,'.'), strlen($filename)-1); // Get the extension from the filename.
 
   // Check if the filetype is allowed, if not DIE and inform the user.
   if(!in_array($ext,$allow))
   {
      
	  $sfa_font_error =true;
	  $sfa_font_msg = __('Only font files (.ttf) are allowed', 'sacf');
	}
 
   // Now check the filesize, if it is too large then DIE and inform the user.
   if(filesize($_FILES['userfile']['tmp_name']) > $max_filesize)
      {
	  $sfa_font_error =true;
	  $sfa_font_msg=__('The file you attempted to upload is too large', 'sacf');
	  }
 
   // Check if we can upload to the specified path, if not DIE and inform the user.
   if(!is_writable($upload_path))
      {
		$sfa_font_error =true;
		$sfa_font_msg=__('You cannot upload to the specified directory, please CHMOD it to 777', 'sacf');
		}	
 
	if(!$sfa_font_error)
	{
   // Upload the file to your specified path.
	if(move_uploaded_file($_FILES['userfile']['tmp_name'],$upload_path . $filename))
        $sfa_font_msg=__('Your file upload was successful','sacf'); // It worked.
      else
         $sfa_font_msg=__('There was an error during the file upload.  Please try again', 'sacf'); 
	}
	
} /*End of upload font*/


if( isset($_POST['sfa_form_submit'] )) 
{				
		$options['b_name'] = $_POST['sfa_bname'];	
		$options['b_email'] = $_POST['sfa_bemail'];
		$options['c_color'] = $_POST['sfa_cColor'];
		$options['c_font'] = $_POST['sfa_fontGroup'];
		$options['c_size'] = $_POST['sfa_cSize'];
		$options['form_size'] = $_POST['sfa_fsize'];
		$options['subject_req'] = $_POST['sfa_subjectReqGroup'];
		$options['phone_req'] = $_POST['sfa_phoneGroup'];
		$options['phone_mask'] = $_POST['sfa_pMask'];
		$options['captcha'] = $_POST['sfa_captchaGroup'];
		$options['subject'] = $_POST['sfa_subjectGroup'];		
		
		//validates email format
		if(!is_email($_POST['sfa_bemail']))
		{
			$sfa_error = true;
			$admin_error['msg'] = '<span>'.__('Enter a valid email', 'sacf').'</span><br/>';
		}	
		else
		{
			$email = sanitize_email($_POST['sfa_bemail']);
			$options['b_email'] = $email;
		}	
		
		//if form size is empty, display error
		if(empty($_POST['sfa_fsize']))
		{
			$sfa_error = true;
			$admin_error['msg'] .= '<span>'.__('Enter form size', 'sacf').'</span><br/>';
		}
		
		//if business name is empty, display error
		if(empty($_POST['sfa_bname']))
		{
			$sfa_error = true;
			$admin_error['msg'] .= '<span>'.__('Enter your business name', 'sacf').'</span><br/>';
		}	
		
		//if captcha font size is empty, display error
		if(empty($_POST['sfa_cSize']))
		{
			$sfa_error = true;
			$admin_error['msg'] .= '<span>'.__('Enter captcha size', 'sacf').'</span><br/>';
		}	
		
		//if no error, update settings
		if(!$sfa_error)
		update_option('sfa_settings', $options);
}
?>

<div class="wrap">
	<div id="icon-options-general" class="icon32"></div>
	<?php    echo '<h2>' . __( 'Smart Form Ajax', 'sacf') . '</h2>'; ?> <br/>
	
		<div class="updated fade" 
		<?php 
		if( !isset( $_REQUEST['sfa_form_submit'] )) 
		echo 'style="display:none"'; ?>><p><strong><?php 
		
		if(!$sfa_error)
			_e('Settings saved.', 'sacf');
			
			else
			echo $admin_error['msg'];
					
		 ?></strong></p></div>

	<form id="sfa_settings_form" method="POST" action="<?php echo str_replace( '%7E', '~', $_SERVER['REQUEST_URI']); ?>">
			
			<p class="sfa-form-sub"><?php _e('Personal Information', 'sacf') ?></p>
			<label for="sfa_bname"><?php _e('Business Name:', 'sacf') ?></label>
			<input type="text" id="sfa_bname" class="inputType" name="sfa_bname" value="<?php echo $options['b_name']; ?>" />	
			
			<label for="sfa_bemail"><?php _e('Business Email:', 'sacf')?></label>
			<input type="text" id="sfa_bemail" class="inputType" name="sfa_bemail" value="<?php echo $options['b_email']; ?>" />
			
			<p class="sfa-form-sub"><?php _e('Form Settings', 'sacf') ?></p>
			<label for="sfa_fsize"><?php _e('Form Width:','sacf')?></label>
			<input type="text" id="sfa_fsize" class="smallField" maxlength="3" name="sfa_fsize" value="<?php echo $options['form_size']; ?>" />
			<span class="sfa_msg">%</span><div class="sfa_clear"></div>		
			
			<label for="sfa_captcha"><?php _e('Display Captcha:', 'sacf')?></label>
			<div class="sfa_radioContainer">
				<ul class="sfa_radioList">
					<li><input type="radio" name="sfa_captchaGroup" id="sfa_captcha_yes" class="radioType" value="1" 
					<?php
						if(sfa_getVal('captcha') == '1')
						echo 'checked="checked"';
					?>/><?php _e('Yes','sacf'); ?></li>
					<li><input type="radio" name="sfa_captchaGroup" id="sfa_captcha_no" class="radioType" value="0" 
					<?php
						if(sfa_getVal('captcha') == '0')
						echo 'checked="checked"';
					?>
					/><?php _e('No','sacf'); ?></li>
				</ul>
			</div>	<div class="sfa_clear"></div>		
			
			<label for="sfa_cColor"><?php _e('Captcha color:', 'sacf')?></label>
			<input type="text" id="sfa_cColor" class="smallField" name="sfa_cColor" value="<?php echo $options['c_color']; ?>" />			
			<div id="colorContainer"><div id="ilctabscolorpicker"></div></div>		<div class="sfa_clear"></div>			
			
			<label for="sfa_cFont"><?php _e('Captcha Fonts:', 'sacf')?></label>
			<div class="sfa_radioContainer">
				<?php sfa_selectFont();  ?>				
			</div><div class="sfa_clear"></div>		
			
			<label for="sfa_cSize"><?php _e('Captcha Font Size:', 'sacf')?></label>
			<input type="text" id="sfa_cSize" class="smallField" maxlength="2" name="sfa_cSize" value="<?php echo $options['c_size']; ?>" />
			<span class="sfa_msg">pixels</span>	<div class="sfa_clear"></div>				
			
			<label for="sfa_subject"><?php _e('Display Subject:', 'sacf')?></label>
			<div class="sfa_radioContainer">
				<ul class="sfa_radioList">
					<li><input type="radio" name="sfa_subjectGroup" id="sfa_subject_yes" class="radioType" value="1" 
					<?php
						if(sfa_getVal('subject') == '1')
						echo 'checked="checked"';
					?>/><?php _e('Yes','sacf'); ?></li>
					<li><input type="radio" name="sfa_subjectGroup" id="sfa_subject_no" class="radioType" value="0" 
					<?php
						if(sfa_getVal('subject') == '0')
						echo 'checked="checked"';
					?>
					/><?php _e('No','sacf'); ?></li>
				</ul>
			</div><div class="sfa_clear"></div>		
								
			<label for="sfa_subject"><?php _e('Subject Requiered:', 'sacf')?></label>
			<div class="sfa_radioContainer">
				<ul class="sfa_radioList">
					<li><input type="radio" name="sfa_subjectReqGroup" id="sfa_subjectReq_yes" class="radioType" value="1" 
					<?php
						if(sfa_getVal('subject_req') == '1')
						echo 'checked="checked"';
					?>/><?php _e('Yes','sacf'); ?></li>
					<li><input type="radio" name="sfa_subjectReqGroup" id="sfa_subjectReq_no" class="radioType" value="0" 
					<?php
						if(sfa_getVal('subject_req') == '0')
						echo 'checked="checked"';
					?>
					/><?php _e('No','sacf'); ?></li>
				</ul>
			</div><div class="sfa_clear"></div>		
			
			<label for="sfa_subject"><?php _e('Phone Requiered:', 'sacf')?></label>
			<div class="sfa_radioContainer">
				<ul class="sfa_radioList">
					<li><input type="radio" name="sfa_phoneGroup" id="sfa_phone_yes" class="radioType" value="1" 
					<?php
						if(sfa_getVal('phone_req') == '1')
						echo 'checked="checked"';
					?>/><?php _e('Yes','sacf'); ?></li>
					<li><input type="radio" name="sfa_phoneGroup" id="sfa_phone_no" class="radioType" value="0" 
					<?php
						if(sfa_getVal('phone_req') == '0')
						echo 'checked="checked"';
					?>/><?php _e('No','sacf'); ?></li>
				</ul>
			</div><div class="sfa_clear"></div>		
			
			<label for="sfa_pMask"><?php _e('Phone Format (Mask):', 'sacf')?></label>
			<input type="text" id="sfa_pMask" class="smallField" name="sfa_pMask" value="<?php echo $options['phone_mask']; ?>" />
			<span class="sfa_msg"><?php _e('Enter only nines Ex. (999) 999-9999','sacf')?></span>
			
			<input type="hidden" name="sfa_form_submit" value="submit" />			
			<input class="button-primary" type="submit" name="Save" value="<?php _e('Update options', 'sacf'); ?>" id="submitbutton" />
			
			
	</form>
	
	<form id="sfa_font" method="POST" enctype="multipart/form-data" action="<?php echo str_replace( '%7E', '~', $_SERVER['REQUEST_URI']); ?>">
			
		<p class="sfa-form-sub"><?php _e('Upload', 'sacf') ?></p>
		
		<label for="fontfile"><?php _e('Select a Font', 'sacf') ?></label> 
		<input type="file" name="userfile" id="fontfile">
		<div class="sfa_clear"></div>
			
		<div
		<?php 
		if( !isset( $_REQUEST['sfa_font_submit'] )) 
		echo 'style="display:none"'; ?>><p><?php 
			if(!$sfa_font_error)
			echo '<strong style="color:green">'.$sfa_font_msg;
			
			else
			echo '<strong style="color:red">'.$sfa_font_msg;
		?></strong></p></div>

		
		<input type="hidden" name="sfa_font_submit" value="submit" />			
		<input class="button-primary" type="submit" name="uploadFont" value="<?php _e('Upload Font','sacf') ?>" />
		
	</form>
    <div class="sfa_clear"></div>
    <p>Pour ajouter le formulaire de contact placer le shortcode suivant dans le champ concerner ou dans l&acute;&eacute;diteur de texte :<code> [sfa_contact_form]</code></p>
</div>
