<?php
/**
 * The theme option name is set as 'options-theme-customizer' here.
 * In your own project, you should use a different option name.
 * I'd recommend using the name of your theme.
 *
 * This option name will be used later when we set up the options
 * for the front end theme customizer.
 */

function optionsframework_option_name() {

	$optionsframework_settings = get_option('optionsframework');
	
	// Edit 'options-theme-customizer' and set your own theme name instead
	$optionsframework_settings['id'] = 'options_theme_customizer';
	update_option('optionsframework', $optionsframework_settings);
}

/**
 * Defines an array of options that will be used to generate the settings page and be saved in the database.
 * When creating the "id" fields, make sure to use all lowercase and no spaces.
 */

function optionsframework_options() {

	// Test data
	$test_array = array(
		'one' => __('One', 'options_framework_theme'),
		'two' => __('Two', 'options_framework_theme'),
		'three' => __('Three', 'options_framework_theme'),
		'four' => __('Four', 'options_framework_theme'),
		'five' => __('Five', 'options_framework_theme')
	);

	// Multicheck Array
	$multicheck_array = array(
		'one' => __('French Toast', 'options_framework_theme'),
		'two' => __('Pancake', 'options_framework_theme'),
		'three' => __('Omelette', 'options_framework_theme'),
		'four' => __('Crepe', 'options_framework_theme'),
		'five' => __('Waffle', 'options_framework_theme')
	);

	// Multicheck Defaults
	$multicheck_defaults = array(
		'one' => '1',
		'five' => '1'
	);

	// Background Defaults
	$background_defaults = array(
		'color' => '',
		'image' => '',
		'repeat' => 'repeat',
		'position' => 'top center',
		'attachment'=>'scroll' );

	// Typography Defaults
	$typography_defaults = array(
		'size' => '20px',
		'face' => 'georgia',
		'style' => 'bold',
		'color' => '#ededed' );
	
	$typography_defaults_slide = array(
		'size' => '16px',
		'style' => 'bold',
		'color' => '#289ACA' );
	
	$typography_defaults_widget = array(
		'size' => '16px',
		'style' => 'bold',
		'color' => '#000' );
		
	$typography_defaults_title_post = array(
		'size' => '20px',
		'style' => 'bold',
		'color' => '#c8c8cc' );
		
	// Typography Options
	$typography_options = array(
		'sizes' => array( '6','12','14','16','20' ),
		'faces' => array( 'Helvetica Neue' => 'Helvetica Neue','Arial' => 'Arial' ),
		'styles' => array( 'normal' => 'Normal','bold' => 'Bold' ),
		'color' => false
	);
	// Header
	$multicheck_header = array( "oui" => "Oui","non" => "Non");
	// menu position
	$multicheck_menu = array( "outside" => "En-dessous de l&acute;ent&ecirc;te.","under" => "Au-dessus de l&acute;ent&ecirc;te. ");
	// menu 2 position
	$multicheck_menu_2 = array( "none" => "Pas de deuxi&egrave;me menu pour l&acute;instant.","outside" => "En-dessous de l&acute;ent&ecirc;te.","under" => "Au-dessus de l&acute;ent&ecirc;te. ");
	// taille police menu
	$font_menu = array("12px" => "12px","13px" => "13px","14px" => "14px","15px" => "15px","16px" => "16px","17px" => "17px");
	
	// Typography Defaults
	$typography_defaults_h1 = array(
		'size' => '28px',
		'style' => 'bold');
	
	$typography_defaults_h2 = array(
		'size' => '24px',
		'style' => 'bold');
		
	$typography_defaults_h3 = array(
		'size' => '20px',
		'style' => 'bold');
		
	$typography_defaults_h4 = array(
		'size' => '18px',
		'style' => 'bold');
	
	$typography_defaults_h5 = array(
		'size' => '16px',
		'style' => 'bold');
		
	$typography_defaults_h6 = array(
		'size' => '14px',
		'style' => 'bold');
		
	$typography_options_h = array(
		'sizes' => array( '9','12','14','16','18','20','21','22','23','24','25','26','27','28','29','30' ),
		'styles' => array( 'normal' => 'Normal','bold' => 'Bold' ),
		'color' => false
	);
	
	$typography_options_post = array(
		'sizes' => array( '9','12','14','16','18','20','21','22','23','24','25','26','27','28','29','30' ),
		'styles' => array( 'normal' => 'Normal','bold' => 'Bold' ),
		'color' => true
	);
	
	
	

	// Pull all the categories into an array
	$options_categories = array();
	$options_categories_obj = get_categories();
	foreach ($options_categories_obj as $category) {
		$options_categories[$category->cat_ID] = $category->cat_name;
	}
	
	// Pull all tags into an array
	$options_tags = array();
	$options_tags_obj = get_tags();
	foreach ( $options_tags_obj as $tag ) {
		$options_tags[$tag->term_id] = $tag->name;
	}


	// Pull all the pages into an array
	$options_pages = array();
	$options_pages_obj = get_pages('sort_column=post_parent,menu_order');
	$options_pages[''] = 'Select a page:';
	foreach ($options_pages_obj as $page) {
		$options_pages[$page->ID] = $page->post_title;
	}

	// If using image radio buttons, define a directory path
	$imagepath =  get_template_directory_uri() . '/images/';

	$options = array();

// Page d'accueil
	$fonts_array = array(
		"'Lucida Grande', Helvetica, Sans-Serif" => "'Lucida Grande', Helvetica, Sans-Serif",
		"'Times New Roman', Times, serif" => "'Times New Roman', Times, serif",
		"'Palatino Linotype', 'Book Antiqua', Palatino, serif" => "'Palatino Linotype', 'Book Antiqua', Palatino, serif",
		"Arial, Helvetica, sans-serif" => "Arial, Helvetica, sans-serif",
		"'Arial Black', Gadget, sans-serif" => "'Arial Black', Gadget, sans-serif",
		"'Comic Sans MS', cursive, sans-serif" => "'Comic Sans MS', cursive, sans-serif",
		"Impact, Charcoal, sans-serif" => "Impact, Charcoal, sans-serif",
		"'Lucida Sans Unicode', 'Lucida Grande', sans-serif" => "'Lucida Sans Unicode', 'Lucida Grande', sans-serif",
		"Verdana, Geneva, sans-serif" => "Verdana, Geneva, sans-serif",
		"Georgia, serif" => "Georgia, serif" );
		
	$header_font_array = array(
		"12px" => "12px",
		"13px" => "13px",
		"14px" => "14px",
		"15px" => "15px",
		"16px" => "16px",
		"17px" => "17px",
		"18px" => "18px",
		"19px" => "19px",
		"20px" => "20px",
		"21px" => "21px",
		"22px" => "22px",
		"23px" => "23px",
		"24px" => "24px",
		"25px" => "25px" );
		
	$header_title_font_array = array(
		"25px" => "25px",
		"26px" => "26px",
		"27px" => "27px",
		"28px" => "28px",
		"29px" => "29px",
		"30px" => "30px" );
	
	$repeat_array = array(
		"repeat" => "R&eacute;p&eacute;ter",
		"no-repeat" => "Ne pas r&eacute;p&eacute;ter");
	
	$position_array = array(
		"center" => "Centrer l&acute;image",
		"left top" => "Mettre en haut et a gauche",
		"left center" => "Mettre a gauche et au centre",
		"left bottom" => "Mettre a gauche et en bas",
		"left center" => "Mettre a gauche et au centre",
		"right top" => "Mettre a droite et en haut",
		"right center" => "Mettre a droite et au centre",
		"right bottom" => "Mettre a droite et en bas",
		"center top" => "Mettre en haut et au centre",
		"center bottom" => "Mettre en bas et au centre");
	
	$fixed_array = array(
		"fixed" => "Fixer l&acute;image(no scrool)",
		"scroll" => "Ne pas fixer l&acute;image ");
	
	
	
	// Gnral
	
	$options[] = array(
		'name' => __('Options G&eacute;n&eacute;ral', 'options_framework_theme'),
		'type' => 'heading');
	
	$options[] = array(
		'name' => __('Favicon', 'options_framework_theme'),
		'desc' => __('Pour avoir une favicon lisible par la plupart des navigateurs, il est pr&eacute;f&eacute;rable que cette image soit au format .ico. 16x16 ou 32x32 pixels(format png accepter)', 'options_framework_theme'),
		'id' => 'favicon',
		'type' => 'upload');
		
	$options[] = array( "name" => "Ent&ecirc;te et pied de page",
						"separ" => "___________________________________________________________________________________",
						"subname" => "",
						"desc" => "Voulez-vous que l&acute;ent&ecirc;te et le pied de page sois en pleine largeur ?",
						"id" => "header_option",
						"std" => "oui", 
						"type" => "radio",
						"options" => $multicheck_header);
	
	$options[] = array(
		"subname" => "",
		'desc' => __('Espace entre le conteneur et le header - footer', 'options_framework_theme'),
		'id' => 'margin_wapper',
		'std' => '20px',
		'class' => 'mini',
		'type' => 'text');
						
	
	
	$options[] = array(
		'name' => __('Page 404', 'options_framework_theme'),
		'desc' => sprintf( __( 'Ajouter votre texte et image ici', 'options_framework_theme' ), 'http://codex.wordpress.org/Function_Reference/wp_editor' ),
		'id' => '404_editor',
		'type' => 'editor',
		'settings' => $wp_editor_settings );
	
// section 1

$options[] = array(
		'name' => __('Pages et articles', 'options_framework_theme'),
		'type' => 'heading');
   // balise h1, h2, h3, h4, h5, h6
   
   $options[] = array(
		'name' => __('Personnalisation des balises h1, h2, h3, h4, h5, h6 pour les pages et articles. ', 'options_framework_theme'),
		'desc' => __('Cliquez pour afficher les options des balises.', 'options_framework_theme'),
		'id' => 'balise_h_showhidden',
		'type' => 'checkbox');

   
	$options[] = array(
		'name' => __('Personnalisation de la balise H1', 'options_framework_theme'),
		'desc' => __('Personnalisation de la taille et du style.', 'options_framework_theme'),
		'id' => "h1_typography",
		'std' => $typography_defaults_h1,
		'type' => 'typography',
		'class' => 'hidden',
		'options' => $typography_options_h );
	
	$options[] = array(
		'name' => __('Personnalisation de la balise H2', 'options_framework_theme'),
		'desc' => __('Personnalisation de la taille et du style.', 'options_framework_theme'),
		'id' => "h2_typography",
		'std' => $typography_defaults_h2,
		'type' => 'typography',
		'class' => 'hidden',
		'options' => $typography_options_h );
	
	$options[] = array(
		'name' => __('Personnalisation de la balise H3', 'options_framework_theme'),
		'desc' => __('Personnalisation de la taille et du style.', 'options_framework_theme'),
		'id' => "h3_typography",
		'std' => $typography_defaults_h3,
		'type' => 'typography',
		'class' => 'hidden',
		'options' => $typography_options_h );
	
	$options[] = array(
		'name' => __('Personnalisation de la balise H4', 'options_framework_theme'),
		'desc' => __('Personnalisation de la taille et du style.', 'options_framework_theme'),
		'id' => "h4_typography",
		'std' => $typography_defaults_h4,
		'type' => 'typography',
		'class' => 'hidden',
		'options' => $typography_options_h );
	
	$options[] = array(
		'name' => __('Personnalisation de la balise H5', 'options_framework_theme'),
		'desc' => __('Personnalisation de la taille et du style.', 'options_framework_theme'),
		'id' => "h5_typography",
		'std' => $typography_defaults_h5,
		'type' => 'typography',
		'class' => 'hidden',
		'options' => $typography_options_h );
	
	$options[] = array(
		'name' => __('Personnalisation de la balise H6', 'options_framework_theme'),
		'desc' => __('Personnalisation de la taille et du style.', 'options_framework_theme'),
		'id' => "h6_typography",
		'std' => $typography_defaults_h6,
		'type' => 'typography',
		'class' => 'hidden',
		'options' => $typography_options_h );
	
	// Personnalisation des titres principal des page et articles
	
	$options[] = array( 'name' => __('Personnalisation du titre principal de vos pages et articles', 'options_framework_theme'),
		'desc' => __('Personnalisation de la taille et du style et couleur.', 'options_framework_theme'),
		'id' => "h2_post_typography",
		'std' => $typography_defaults_title_post,
		'type' => 'typography',
		'options' => $typography_options_post );
	
	$options[] = array(
		
		'desc' => __('Hauteur de ligne.', 'options_framework_theme'),
		'id' => 'h2_post_line',
		'std' => '25px',
		'class' => 'mini',
		'type' => 'text');
	
	$options[] = array(
		
		'desc' => __('Marge du bas.', 'options_framework_theme'),
		'id' => 'h2_post_margin',
		'std' => '20px',
		'class' => 'mini',
		'type' => 'text');
		
		
	
// ************************************** Commentaire *******************************************
	$options[] = array(
		'name' => __('Commentaires', 'options_framework_theme'),
		'type' => 'heading');
		
	$options[] = array(
		'name' => __('Couleur des &eacute;l&eacute;ments', 'options_framework_theme'),
		'desc' => __('Choisissez une couleur pour les &eacute;l&eacute;ments titre,r&eacute;pondre,envoyer.', 'options_framework_theme'),
		'id' => 'comment_color',
		'std' => '#454545',
		'type' => 'color' );
		
	$options[] = array(
		'desc' => __('Choisissez une couleur pour le texte des &eacute;l&eacute;ments.', 'options_framework_theme'),
		'id' => 'comment_txt_color',
		'std' => '#ffffff',
		'type' => 'color' );
	
	$options[] = array(
		'desc' => __('Choisissez une couleur pour les liens du bouton r&eacute;pondre et envoyer avant le passsage de la souris.', 'options_framework_theme'),
		'id' => 'comment_a_color',
		'std' => '#ffffff',
		'type' => 'color' );
		
	$options[] = array(
		'desc' => __('Choisissez une couleur pour les liens du bouton r&eacute;pondre et envoyer au passsage de la souris.', 'options_framework_theme'),
		'id' => 'comment_hover_color',
		'std' => '#ffffff',
		'type' => 'color' );
	
	
	
// ************************************** Footer Wdget *******************************************
	$options[] = array(
		'name' => __('Pied de page Widget', 'options_framework_theme'),
		'type' => 'heading');
	
	
	$options[] = array(
		"name" => "Couleur de fond du pied de page(footer)",
		'desc' => __('Choisissez une couleur de fond pour le pied de page.', 'options_framework_theme'),
		"id" => "bg_footer_widget",
		"std" => "#666666",
		"type" => "color" );
	
	
	$options[] = array(
		'name' => __('Titre des Widget.', 'options_framework_theme'),
		'desc' => __('Taille, Style, Couleur.', 'options_framework_theme'),
		'id' => "title_footer_color",
		'std' => $typography_defaults_title_post,
		'type' => 'typography',
		'options' => $typography_options_post
		 );
	
	$options[] = array(
		"name" => "Typographie et liens",
		'desc' => __('Choisissez une couleur pour les liens avant le passage de la souris.', 'options_framework_theme'),
		"id" => "link_footer_a",
		"std" => "#ffffff",
		"type" => "color" );
	
	$options[] = array(
		'desc' => __('Choisissez une couleur pour les liens au passage de la souris.', 'options_framework_theme'),
		"id" => "link_footer_hover",
		"std" => "#ffffff",
		"type" => "color" );
	
	
	
	$options[] = array(
		'desc' => __('Choisissez une couleur pour le texte des Widgets.', 'options_framework_theme'),
		"id" => "txt_footer_color",
		"std" => "#ffffff",
		"type" => "color" );
		
		
	// editeur pied de page
	
	$options[] = array(
		'name' => __('Pied de page mentions', 'options_framework_theme'),
		'desc' => __('Choisissez une couleur de fond pour les mentions.', 'options_framework_theme'),
		"id" => "mention_footer_color",
		"std" => "#666666",
		"type" => "color" );
	
	$options[] = array(
		"name" => "Taille du texte.",
		"id" => "txt_fonts_mentions",
		"type" => "select",
		"options" => $header_font_array );
		
	$wp_editor_settings = array(
		'wpautop' => false, // Default
		'textarea_rows' => 5,
		'tinymce' => array( 'plugins' => 'wordpress' )
	);
	
	
	
	$options[] = array(
		'desc' => sprintf( __( 'Ajouter vos mentions ici', 'options_framework_theme' ), 'http://codex.wordpress.org/Function_Reference/wp_editor' ),
		'id' => 'mention_editor',
		'type' => 'editor',
		'settings' => $wp_editor_settings );


// ************************************** Sidebar *******************************************
	$options[] = array(
		'name' => __('Sidebar', 'options_framework_theme'),
		'type' => 'heading');

	$options[] = array(
		'name' => __('Param&egrave;tre Sidebar des articles et pages.', 'options_framework_theme'),
		'desc' => __('Taille, Style, Couleur.', 'options_framework_theme'),
		'id' => "sidebar_typography",
		'std' => $typography_defaults_widget,
		'type' => 'typography',
		'options' => $typography_options_post );
		
	$options[] = array(
		"name" => "Choisissez une couleur de fond pour les titres des Widgets",
		"id" => "bg_title_sidebar",
		"std" => "",
		"type" => "color" );

	
	

	// menu otions
	$options[] = array( "name" => "Menu",
						"type" => "heading");
							
	$options[] = array( "name" => "Options pour le premier menu",
						"separ" => "___________________________________________________________________________________",
						"subname" => "Couleur de fond du menu ",
						"desc" => "Choissiez une couleur de fond pour la bar de navigation principale",
						"id" => "bar_nav_color",
						"std" => "#000000",
						"type" => "color");
	
	$options[] = array( "subname" => "Couleur du texte du menu. ",
						"desc" => "Choissiez la couleur du texte pour le menu",
						"id" => "bar_txt_color",
						"std" => "#ebebeb",
						"type" => "color");
						
	$options[] = array( "subname" => "Couleur de fond du menu au passage de la souris.",
						"desc" => "Choissiez une couleur de fond au passage de la souris pour la bar de navigation principale (<em><strong>Laisser le champ vide pour ne pas afficher de couleur de fond</strong></em>)",
						"id" => "bar_link_color",
						"std" => "",
						"type" => "color");
						
	
	$options[] = array( "subname" => "Couleur du texte au passage de la souris. ",
						"desc" => "Choissiez la couleur du texte au passage de la souris. ",
						"id" => "link_txt_color",
						"std" => "#e04216",
						"type" => "color");
						
	$options[] = array( 
						"desc" => "Choisissez la taille du texte du menu .",
						"id" => "font_size_menu",
						"std" => "14px",
						"type" => "select",
						"class" => "custom-mini", //mini, tiny, small
						"options" => $font_menu);
						
	$options[] = array( "subname" => "Couleur de fond pour les sous-menu. ",
						"desc" => "Choissiez la de fond pour les sous-menu.",
						"id" => "box_submenu_color",
						"std" => "#e6e6e6",
						"type" => "color");
						
	$options[] = array( "subname" => "Taille du texte pour le sous-menu  ",
						"desc" => "Choisissez la taille du texte du sous-menu .",
						"id" => "font_size_sous_menu",
						"std" => "12px",
						"type" => "select",
						"class" => "custom-mini", //mini, tiny, small
						"options" => $font_menu);
						
	$options[] = array( "subname" => "Couleur du texte pour le sous-menu. ",
						"desc" => "Choissiez la couleur du texte avant le passage de la souris. ",
						"id" => "link_txt_sub",
						"std" => "#000000",
						"type" => "color");
						
	$options[] = array( "subname" => "Couleur du texte au passage de la souris. ",
						"desc" => "Choissiez la couleur du texte au passage de la souris. ",
						"id" => "link_txt__sub_hover",
						"std" => "#e04216",
						"type" => "color");
						
	$options[] = array( "subname" => "Largeur du sous-menu.",
						"desc" => "Indiquez la largeur du sous-menu en <strong>px</strong>.",
						"id" => "sub_menu_size",
						"std" => "180px",
						"class" => "mini",
						"type" => "text");
						
						
	$options[] = array(
						'desc' => __('Cochez cette case pour affich&eacute; un icon home.', 'options_framework_theme'),
						'id' => 'link_home_1',
						'std' => '0',
						'type' => 'checkbox');
						
	$options[] = array( "name" => "Position du menu",
						"separ" => "___________________________________________________________________________________",
						"subname" => "Ou voulez-vous positioner le menu ?",
						"desc" => "",
						"id" => "menu_option",
						"std" => "under", 
						"type" => "radio",
						"options" => $multicheck_menu);
// custom live
$options[] = array( "name" => "Page d&acute;accueil",
		"type" => "heading" );
	
	

	$options['font_select_header'] = array(
		"name" => "Type de police(header)",
		"id" => "font_select_header",
		"std" => "'Lucida Grande', Helvetica, Sans-Serif",
		"type" => "select",
		"options" => $fonts_array );
	
	$options['header_font_array'] = array(
		"name" => "Taille du titre",
		"id" => "header_font_array",
		"std" => "13px",
		"type" => "select",
		"options" => $header_title_font_array );

	
	$options['title_color_header'] = array(
		"name" => "Couleur du titre",
		"id" => "title_color_header",
		"std" => "#666666",
		"type" => "color" );	
	
	
	$options['desc_font_size'] = array(
		"name" => "Taille de la police pour la description",
		"id" => "desc_font_size",
		"std" => "14px",
		"type" => "select",
		"options" => $header_font_array );
	
	$options['desc_color_header'] = array(
		"name" => "Couleur de la description",
		"id" => "desc_color_header",
		"std" => "#666666",
		"type" => "color" );
		
	$options[] = array(
		'name' => __('Logo ou image', 'options_framework_theme'),
		'desc' => __('Envoyer un logo ou une image pour l&acute;ent&ecirc;te du site.', 'options_framework_theme'),
		'id' => 'logo_uploader',
		'type' => 'upload');
	
	$options['header_height'] = array(
		"name" => "Hauteur de l&acute;ent&ecirc;te",
		"id" => "header_height",
		"std" => "200px",
		"type" => "text" );
		
	$options['margin_left_logo'] = array(
		"name" => "Marge de gauche pour le logo",
		"id" => "margin_left_logo",
		"std" => "10px",
		"type" => "text" );
	
	$options['margin_top_logo'] = array(
		"name" => "Marge de haut pour le logo",
		"id" => "margin_top_logo",
		"std" => "10px",
		"type" => "text" );

	$options['example_radio'] = array(
		"name" => "Radio Buttons",
		"id" => "example_radio",
		"std" => "Third",
		"type" => "radio",
		"options" => $test_array );

	$options['example_checkbox'] = array(
		"name" => "Input Checkbox",
		"desc" => "This is a work in progress.  There is are some issues with how the front end customizer saves checkbox options, and how the Options Framework does.  Bear with me a bit while I work on a solution.",
		"id" => "example_checkbox",
		"std" => "1",
		"type" => "checkbox" );

	$options['example_uploader'] = array(
		"name" => "Uploader Test",
		"desc" => "This creates a full size uploader that previews the image.",
		"id" => "example_uploader",
		"type" => "upload" );
		
	$options['example_colorpicker'] = array(
		"name" => "Couleur de fond pour l&acute;ent&ecirc;te",
		"id" => "example_colorpicker",
		"std" => "#f2f2f2",
		"type" => "color" );
		
	// arirre plan du site
	
	$options['background_uploader'] = array(
		"name" => "Image ou texture de l&acute;arri&egrave;re plan",
		"desc" => "",
		"id" => "background_uploader",
		"type" => "upload" );
		
	$options['background_colorpicker'] = array(
		"name" => "Couleur de l&acute;arri&egrave;re plan",
		"id" => "background_colorpicker",
		"std" => "#3b3939",
		"type" => "color" );
	
	$options['repeat_img'] = array(
		"name" => "option de l&acute;image d&acute;arri&egrave;re pla",
		"id" => "repeat_img",
		"std" => "no-repeat",
		"type" => "radio",
		"options" => $repeat_array );
	
	$options['fixed_img'] = array(
		"name" => " Fixer l&acute;image",
		"id" => "fixed_img",
		"std" => "scroll",
		"type" => "radio",
		"options" => $fixed_array );
	
	$options['position_img'] = array(
		"name" => "Position de l&acute;image",
		"id" => "position_img",
		"std" => "no-repeat",
		"type" => "radio",
		"options" => $position_array );
	// typographie gnrale
	
	$options['font_select_all'] = array(
		"name" => "Type de police(header)",
		"id" => "font_select_all",
		"std" => "'Lucida Grande', Helvetica, Sans-Serif",
		"type" => "select",
		"options" => $fonts_array );
		
	$options['all_font_array'] = array(
		"name" => "Taille de la police",
		"id" => "all_font_array",
		"std" => "13px",
		"type" => "select",
		"options" => $header_font_array );
	
	$options['line_fonts_all'] = array(
		"name" => "Espace entre les lignes",
		"id" => "line_fonts_all",
		"std" => "18px",
		"type" => "text" );
	
	$options['link_a_colorpicker'] = array(
		"name" => "Couleur des liens avant le passage de la souris",
		"id" => "link_a_colorpicker",
		"std" => "#818277",
		"type" => "color" );
	
	$options['link_hover_colorpicker'] = array(
		"name" => "Couleur des liens au passage de la souris",
		"id" => "link_hover_colorpicker",
		"std" => "#1a4bb9",
		"type" => "color" );
	
	$options['link_visited_colorpicker'] = array(
		"name" => "Couleur des liens qui ont &eacute;t&eacute; visiter",
		"id" => "link_visited_colorpicker",
		"std" => "#0965b0",
		"type" => "color" );
	
	// Accueil Fin		

	return $options;
}

/**
 * Front End Customizer
 *
 * WordPress 3.4 Required
 */

add_action( 'customize_register', 'options_theme_customizer_register' );

function options_theme_customizer_register($wp_customize) {

	/**
	 * This is optional, but if you want to reuse some of the defaults
	 * or values you already have built in the options panel, you
	 * can load them into $options for easy reference
	 */
	 
	$options = optionsframework_options();
	
	/* Logo ou image */

	$wp_customize->add_section( 'options_theme_customizer_extended', array(
		'title' => __( 'Header insertion Logo ou Image', 'options_theme_customizer' ),
		'priority' => 110
	) );
	// upload image
	$wp_customize->add_setting( 'options_theme_customizer[logo_uploader]', array(
		'type' => 'option'
	) );
	
	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'logo_uploader', array(
		'label' => $options['logo_uploader']['name'],
		'section' => 'options_theme_customizer_extended',
		'settings' => 'options_theme_customizer[logo_uploader]'
	) ) );
	
	// hauteur de l'entte
	$wp_customize->add_setting( 'options_theme_customizer[header_height]', array(
		'default' => $options['header_height']['std'],
		'type' => 'option'
	) );

	$wp_customize->add_control( 'options_theme_customizer_header_height', array(
		'label' => $options['header_height']['name'],
		'section' => 'options_theme_customizer_extended',
		'settings' => 'options_theme_customizer[header_height]',
		'type' => $options['header_height']['type']
	) );
	// marge gauche
	
	$wp_customize->add_setting( 'options_theme_customizer[margin_left_logo]', array(
		'default' => $options['margin_left_logo']['std'],
		'type' => 'option'
	) );

	$wp_customize->add_control( 'options_theme_customizer_margin_left_logo', array(
		'label' => $options['margin_left_logo']['name'],
		'section' => 'options_theme_customizer_extended',
		'settings' => 'options_theme_customizer[margin_left_logo]',
		'type' => $options['margin_left_logo']['type']
	) );
	
	// marge haut
	$wp_customize->add_setting( 'options_theme_customizer[margin_top_logo]', array(
		'default' => $options['margin_top_logo']['std'],
		'type' => 'option'
	) );

	$wp_customize->add_control( 'options_theme_customizer_margin_top_logo', array(
		'label' => $options['margin_top_logo']['name'],
		'section' => 'options_theme_customizer_extended',
		'settings' => 'options_theme_customizer[margin_top_logo]',
		'type' => $options['margin_top_logo']['type']
	) );
	//
	$wp_customize->add_setting( 'options_theme_customizer[example_colorpicker]', array(
		'default' => $options['example_colorpicker']['std'],
		'type' => 'option'
	) );
	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'link_color', array(
		'label'   => $options['example_colorpicker']['name'],
		'section' => 'options_theme_customizer_extended',
		'settings'   => 'options_theme_customizer[example_colorpicker]'
	) ) );
	
	/* Typographie */

	$wp_customize->add_section( 'options_theme_customizer_basic', array(
		'title' => __( 'Param&egrave;tre titre et description', 'options_theme_customizer' ),
		'priority' => 100
	) );
	

	// choix de la police
	$wp_customize->add_setting( 'options_theme_customizer[font_select_header]', array(
		'default' => $options['font_select_header']['std'],
		'type' => 'option'
	) );
	
	$wp_customize->add_control( 'options_theme_customizer_font_select_header', array(
		'label' => $options['font_select_header']['name'],
		'section' => 'options_theme_customizer_basic',
		'settings' => 'options_theme_customizer[font_select_header]',
		'type' => $options['font_select_header']['type'],
		'choices' => $options['font_select_header']['options']
	) );
	
	
	// police header
	$wp_customize->add_setting( 'options_theme_customizer[header_font_array]', array(
		'default' => $options['header_font_array']['std'],
		'type' => 'option'
	) );

	$wp_customize->add_control( 'options_theme_customizer_header_font_array', array(
		'label' => $options['header_font_array']['name'],
		'section' => 'options_theme_customizer_basic',
		'settings' => 'options_theme_customizer[header_font_array]',
		'type' => $options['header_font_array']['type'],
		'choices' => $options['header_font_array']['options']
	) );
	// police header fin
	
	// style de la police
	$wp_customize->add_setting( 'options_theme_customizer[style_font_array]', array(
		'default' => $options['style_font_array']['std'],
		'type' => 'option'
	) );
	
	$wp_customize->add_control( 'options_theme_customizer_style_font_array', array(
		'label' => $options['style_font_array']['name'],
		'section' => 'options_theme_customizer_basic',
		'settings' => 'options_theme_customizer[style_font_array]',
		'type' => $options['style_font_array']['type'],
		'choices' => $options['style_font_array']['options']
	) );
	
	// couleur du titre
	
	$wp_customize->add_setting( 'options_theme_customizer[title_color_header]', array(
		'default' => $options['title_color_header']['std'],
		'type' => 'option'
	) );
	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'title_link_color', array(
		'label'   => $options['title_color_header']['name'],
		'section' => 'options_theme_customizer_basic',
		'settings'   => 'options_theme_customizer[title_color_header]'
	) ) );
	
	// police header description
	$wp_customize->add_setting( 'options_theme_customizer[desc_font_size]', array(
		'default' => $options['desc_font_size']['std'],
		'type' => 'option'
	) );

	$wp_customize->add_control( 'options_theme_customizer_desc_font_size', array(
		'label' => $options['desc_font_size']['name'],
		'section' => 'options_theme_customizer_basic',
		'settings' => 'options_theme_customizer[desc_font_size]',
		'type' => $options['desc_font_size']['type'],
		'choices' => $options['desc_font_size']['options']
	) );
	// police header description fin

// style de la police desc
 	$wp_customize->add_setting( 'options_theme_customizer[desc_font_style]', array(
		'default' => $options['desc_font_style']['std'],
		'type' => 'option'
	) );
	
	$wp_customize->add_control( 'options_theme_customizer_desc_font_style', array(
		'label' => $options['desc_font_style']['name'],
		'section' => 'options_theme_customizer_basic',
		'settings' => 'options_theme_customizer[desc_font_style]',
		'type' => $options['desc_font_style']['type'],
		'choices' => $options['desc_font_style']['options']
	) );
// style de la police desc fin	
// couleur de la description
	
	$wp_customize->add_setting( 'options_theme_customizer[desc_color_header]', array(
		'default' => $options['desc_color_header']['std'],
		'type' => 'option'
	) );
	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'desc_link_color', array(
		'label'   => $options['desc_color_header']['name'],
		'section' => 'options_theme_customizer_basic',
		'settings'   => 'options_theme_customizer[desc_color_header]'
	) ) );
		
		
	
	/* Arriere plan du site */

	$wp_customize->add_section( 'options_theme_customizer_back', array(
		'title' => __( 'Arri&egrave;re plan du site', 'options_theme_customizer' ),
		'priority' => 115
	) );
	// upload image
	$wp_customize->add_setting( 'options_theme_customizer[background_uploader]', array(
		'type' => 'option'
	) );
	
	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'background_uploader', array(
		'label' => $options['background_uploader']['name'],
		'section' => 'options_theme_customizer_back',
		'settings' => 'options_theme_customizer[background_uploader]'
	) ) );
	
	// option image
	$wp_customize->add_setting( 'options_theme_customizer[repeat_img]', array(
		'default' => $options['repeat_img']['std'],
		'type' => 'option'
	) );

	$wp_customize->add_control( 'options_theme_customizer_repeat_img', array(
		'label' => $options['repeat_img']['name'],
		'section' => 'options_theme_customizer_back',
		'settings' => 'options_theme_customizer[repeat_img]',
		'type' => $options['repeat_img']['type'],
		'choices' => $options['repeat_img']['options']
	) );
	// fixer
	$wp_customize->add_setting( 'options_theme_customizer[fixed_img]', array(
		'default' => $options['fixed_img']['std'],
		'type' => 'option'
	) );

	$wp_customize->add_control( 'options_theme_customizer_fixed_img', array(
		'label' => $options['fixed_img']['name'],
		'section' => 'options_theme_customizer_back',
		'settings' => 'options_theme_customizer[fixed_img]',
		'type' => $options['fixed_img']['type'],
		'choices' => $options['fixed_img']['options']
	) );
	// position
	$wp_customize->add_setting( 'options_theme_customizer[position_img]', array(
		'default' => $options['position_img']['std'],
		'type' => 'option'
	) );

	$wp_customize->add_control( 'options_theme_customizer_position_img', array(
		'label' => $options['repeat_img']['name'],
		'section' => 'options_theme_customizer_back',
		'settings' => 'options_theme_customizer[position_img]',
		'type' => $options['position_img']['type'],
		'choices' => $options['position_img']['options']
	) );
	
	// couleur arrire plan
	
	$wp_customize->add_setting( 'options_theme_customizer[background_colorpicker]', array(
		'default' => $options['background_colorpicker']['std'],
		'type' => 'option'
	) );
	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'background_color', array(
		'label'   => $options['background_colorpicker']['name'],
		'section' => 'options_theme_customizer_back',
		'settings'   => 'options_theme_customizer[background_colorpicker]'
	) ) );
	
	
	/* Typographie gnrale du site */

	$wp_customize->add_section( 'options_theme_customizer_typo', array(
		'title' => __( 'Typographie g&eacute;n&eacute;rale du site', 'options_theme_customizer' ),
		'priority' => 105
	) );
	

	// choix de la police
	$wp_customize->add_setting( 'options_theme_customizer[font_select_all]', array(
		'default' => $options['font_select_all']['std'],
		'type' => 'option'
	) );
	
	$wp_customize->add_control( 'options_theme_customizer_font_select_all', array(
		'label' => $options['font_select_all']['name'],
		'section' => 'options_theme_customizer_typo',
		'settings' => 'options_theme_customizer[font_select_all]',
		'type' => $options['font_select_all']['type'],
		'choices' => $options['font_select_all']['options']
	) );
	
	
	// police taille
	$wp_customize->add_setting( 'options_theme_customizer[all_font_array]', array(
		'default' => $options['all_font_array']['std'],
		'type' => 'option'
	) );

	$wp_customize->add_control( 'options_theme_customizer_all_font_array', array(
		'label' => $options['all_font_array']['name'],
		'section' => 'options_theme_customizer_typo',
		'settings' => 'options_theme_customizer[all_font_array]',
		'type' => $options['all_font_array']['type'],
		'choices' => $options['all_font_array']['options']
	) );
	
	// hauteur de ligne
	$wp_customize->add_setting( 'options_theme_customizer[line_fonts_all]', array(
		'default' => $options['line_fonts_all']['std'],
		'type' => 'option'
	) );

	$wp_customize->add_control( 'options_theme_customizer_line_fonts_all', array(
		'label' => $options['line_fonts_all']['name'],
		'section' => 'options_theme_customizer_typo',
		'settings' => 'options_theme_customizer[line_fonts_all]',
		'type' => $options['line_fonts_all']['type']
	) );
	
	
	$wp_customize->add_setting( 'options_theme_customizer[link_a_colorpicker]', array(
		'default' => $options['link_a_colorpicker']['std'],
		'type' => 'option'
	) );
	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'link_a_color', array(
		'label'   => $options['link_a_colorpicker']['name'],
		'section' => 'options_theme_customizer_typo',
		'settings'   => 'options_theme_customizer[link_a_colorpicker]'
	) ) );
	
	$wp_customize->add_setting( 'options_theme_customizer[link_hover_colorpicker]', array(
		'default' => $options['link_hover_colorpicker']['std'],
		'type' => 'option'
	) );
	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'link_hover_color', array(
		'label'   => $options['link_hover_colorpicker']['name'],
		'section' => 'options_theme_customizer_typo',
		'settings'   => 'options_theme_customizer[link_hover_colorpicker]'
	) ) );
	
	$wp_customize->add_setting( 'options_theme_customizer[link_visited_colorpicker]', array(
		'default' => $options['link_visited_colorpicker']['std'],
		'type' => 'option'
	) );
	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'link_visited_color', array(
		'label'   => $options['link_visited_colorpicker']['name'],
		'section' => 'options_theme_customizer_typo',
		'settings'   => 'options_theme_customizer[link_visited_colorpicker]'
	) ) );
	// police gnrale fin
}
/*
 * This is an example of how to add custom scripts to the options panel.
 * This example shows/hides an option when a checkbox is clicked.
 */

add_action('optionsframework_custom_scripts', 'optionsframework_custom_scripts');

function optionsframework_custom_scripts() { ?>

<script type="text/javascript">
jQuery(document).ready(function($) {

	$('#balise_h_showhidden').click(function() {
  		$('#section-h1_typography,#section-h2_typography,#section-h3_typography,#section-h4_typography,#section-h5_typography,#section-h6_typography').fadeToggle(400);
	
	
	
	});

	if ($('#example_showhidden:checked').val() !== undefined) {
		$('#section-h1_typography,#section-h2_typography,#section-h3_typography,#section-h4_typography,#section-h5_typography,#section-h6_typography').show();
	}

});
</script>

<?php
}